﻿#define _CRT_SECURE_NO_WARNINGS
#include <iostream>
#include <algorithm>
#include <vector>
#include <deque>
#include <map>
#include <set>
#include <cmath>
#include <iomanip>
#include <cstdio>
#include <bitset>
#include <random>
#include <ctime>
#include <queue>
#include <cassert>
#include <array>
#include <unordered_map>
#include <unordered_set>
#include <string>
#define endl '\n'

using namespace std;
using ll = long long;
using ld = long double;
const int N = 2e5 + 10;

struct tree {
	vector <int> x;
	int sz;
	void build(vector <int> a) {
		sz = 1;
		while (sz < a.size())
			sz *= 2;
		x.resize(sz * 2, 1e9);
		for (int i = 0; i < a.size(); i++)
			x[i + sz] = a[i];
		for (int i = sz - 1; i > 0; i--)
			x[i] = min(x[i * 2], x[i * 2 + 1]);
	}
	int get(int v, int l, int r, int ql, int qr) {
		if (l >= qr || r <= ql)
			return 1e9;
		if (ql <= l && r <= qr)
			return x[v];
		int m = (l + r) / 2;
		return min(get(v * 2, l, m, ql, qr), get(v * 2 + 1, m, r, ql, qr));
	}
	int get(int l, int r) {
		return get(1, 0, sz, l, r + 1);
	}
} d;

void solve() {
	int n, q;
	string s;
	cin >> n >> q >> s;
	vector <int> bl(n);
	for (int i = 0; i < n; i++) {
		bl[i] = s[i] == '(' ? 1 : -1;
		if (i)
			bl[i] += bl[i - 1];
	}
	d.build(bl);
	while (q--) {
		int l, r;
		cin >> l >> r;
		l--;
		r--;
		int back = bl[r], dop = 0, res = 0, C = 0;
		if (l)
			back -= bl[l - 1], C = bl[l - 1];
		if (back <= 0)
			dop = abs(back);
		res += abs(back);
		int L = l - 1, R = r + 1;
		while (R - L > 1) {
			int M = (L + R) / 2;
			if (d.get(M, r) - C >= (M ? bl[M - 1] - C : 0) - dop)
				R = M;
			else
				L = M;
		}
		assert(L != r);
		cout << L + res - (l - 1) << endl;
	}
}

int main() {
#ifdef _DEBUG
	freopen("input.txt", "r", stdin);
#else 
	ios_base::sync_with_stdio(0);
	cin.tie(0);
#endif 
	int t = 1;
	//cin >> t;
	while (t--) {
		solve();
		cout << endl;
	}
}
